// rfid2demoDlg.cpp : implementation file
#include "stdafx.h"
#include "rfid1demo.h"
#include "rfid1demoDlg.h"
#include "FTD2XX.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define ascitohex(c)    (c <= '9' ? c - '0' : ((c <= 'F') ? c-'A'+10 : c - 'a'+10 ))
#define MYBUFFERSIZE 3000
unsigned char grx[MYBUFFERSIZE];//global receive buffer

int valid_port;
FT_HANDLE m_ftHandle;
CString g_str_array[300];
int data8[8];//array for holding 8 blocks



// CAboutDlg dialog used for App About
class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Crfid2demoDlg dialog

CRfid1demoDlg::CRfid1demoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRfid1demoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRfid1demoDlg)
	m_NumTags = _T("");
	m_MyText = _T("");
	m_PortStatus = _T("");
	m_NumChars = 0;
	m_Addr = _T("00");
	m_Data = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_ReadMode = 0;
	m_MyDebug = 0;
}

void CRfid1demoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRfid1demoDlg)
	DDX_Control(pDX, IDC_PROGRESS1, m_Progress);
	DDX_Control(pDX, IDC_LIST1, m_SniffList);
	DDX_Text(pDX, IDC_EDIT_NUMTAGS, m_NumTags);
	DDX_Text(pDX, IDC_EDIT_MYTEXT, m_MyText);
	DDV_MaxChars(pDX, m_MyText, 256);
	DDX_Text(pDX, IDC_EDIT_STATUS, m_PortStatus);
	DDX_Text(pDX, IDC_EDIT_NUM_CHARS, m_NumChars);
	DDX_Text(pDX, IDC_EDIT_BLOCK_ADDR, m_Addr);
	DDX_Text(pDX, IDC_EDIT_BLOCK_32BITDATA2, m_Data);
	//}}AFX_DATA_MAP
	DDX_Radio(pDX, IDC_RADIO_FINDTAGS, m_ReadMode);
	DDX_Text(pDX, IDC_EDIT_MYDEBUG, m_MyDebug);
}

BEGIN_MESSAGE_MAP(CRfid1demoDlg, CDialog)
	//{{AFX_MSG_MAP(CRfid1demoDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTONREAD, OnButtonread)
	ON_EN_CHANGE(IDC_EDIT_MYTEXT, OnChangeEditMytext)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, OnButtonClear)
	ON_BN_CLICKED(IDC_BUTTON_WRITE_TAG, OnButtonWriteTag)
	ON_BN_CLICKED(IDC_BUTTON_TEST_PATTERN, OnButtonTestPattern)
	ON_BN_CLICKED(IDC_BUTTON_WRITE_SINGLE, OnButtonWriteSingle)
	ON_BN_CLICKED(IDC_BUTTON_READ_BLOCK, OnButtonReadBlock)
	ON_BN_CLICKED(IDC_BUTTON_STAY_QUIET, OnButtonStayQuiet)
	ON_BN_CLICKED(IDC_BUTTON_RESET, OnButtonReset)
	ON_BN_CLICKED(IDC_BUTTON_LOCK_BLOCK, OnButtonLockBlock)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON_PING, &CRfid1demoDlg::OnBnClickedButtonPing)
	ON_BN_CLICKED(IDC_BUTTON_INT_ANT, &CRfid1demoDlg::OnBnClickedButtonIntAnt)
	ON_BN_CLICKED(IDC_BUTTON_EXT_ANT, &CRfid1demoDlg::OnBnClickedButtonExtAnt)
	ON_BN_CLICKED(IDC_RADIO_FINDTAGS, &CRfid1demoDlg::OnBnClickedRadioFindtags)
	ON_BN_CLICKED(IDC_RADIO_INVENTORY, &CRfid1demoDlg::OnBnClickedRadioInventory)
	ON_BN_CLICKED(IDC_RADIO_MANUALMODE, &CRfid1demoDlg::OnBnClickedRadioManualmode)
	ON_BN_CLICKED(IDC_RADIO_INVENTORY2, &CRfid1demoDlg::OnBnClickedRadioInventory2)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRfid1demoDlg message handlers

void CRfid1demoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CRfid1demoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CRfid1demoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


//**********************************************************************************************
BOOL CRfid1demoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	valid_port=0;	
	int ret = OpenPort(1);//reset
	if(ret==0)
		SetTimer(100, 250, NULL);

	return TRUE;  // return TRUE  unless you set the focus to a control
}


//**********************************************************************************************
int CRfid1demoDlg::OpenPort(int reset)
{
	DWORD numDevs;
	CString sss;

	valid_port=0;//init
	FT_STATUS status = FT_ListDevices(&numDevs, NULL, FT_LIST_NUMBER_ONLY);
	if(status == FT_OK) 
	{
		if((int)numDevs > 0)
		{
			FT_STATUS status = FT_OpenEx((PVOID)(LPCTSTR)"DLP-RFID2-LRN", FT_OPEN_BY_DESCRIPTION, &m_ftHandle);
			if(status != FT_OK) 
			{
				AfxMessageBox("Error: Could not open DLP-RFID2 Reader.");				
				return 1;
			}
			else
			{
				FT_Purge(m_ftHandle, FT_PURGE_RX || FT_PURGE_TX); 
				FT_SetTimeouts(m_ftHandle, 100, 100);
				FT_SetBaudRate(m_ftHandle, 115200);
				
				valid_port=1;
				
				if(reset)
					reset_module();
			}
		}
		else
		{
			sss.Format("No RFID2 Detected");
			m_SniffList.InsertString(0,sss);
			UpdateWindow();
			AfxMessageBox("Error: No reader detected.");				
			return 2;
		}
	}
	else
	{
		sss.Format("No RFID2 Detected");
		m_SniffList.InsertString(0,sss);
		UpdateWindow();
		AfxMessageBox("Error: No reader detected.");	
		return 3;
	}

	return 0;
}

//**********************************************************************
void CRfid1demoDlg::reset_module()
{
	FT_STATUS status;

	//set DTR
	status = FT_SetDtr(m_ftHandle);
	Sleep(500); 

	//Clear DTR
	status = FT_ClrDtr(m_ftHandle);
	Sleep(500);
}

//**********************************************************************
void CRfid1demoDlg::OnTimer(UINT nIDEvent) 
{
	DWORD AmountInRxQueue, BytesReturned;
	unsigned char rx[200];
	CString sss;
	int pos;

	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID2 Reader not found");
		return;
	}


	if(m_ReadMode==0) //if find tags mode...
	{
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
		if(AmountInRxQueue>195) AmountInRxQueue = 195;
		FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);

		sss.Format("%s", rx);
		pos = sss.Find("]", 0);  
		if(pos>8)
		{
			sss.SetAt(pos+1, 0x00);
			m_SniffList.InsertString(0,sss);//display the find tags data
		}
	}

	if(m_ReadMode==1) //if manual mode
	{
	
	}

	if(m_ReadMode==2) //if 16-slot inventory mode
	{
		KillTimer(100);
		Read16slot();	
		SetTimer(100, 250, NULL);
	}

	if(m_ReadMode==3) //if 1-slot inventory mode
	{
		KillTimer(100);
		ReadSingleSlot();	
		SetTimer(100, 250, NULL);
	}

	CDialog::OnTimer(nIDEvent);
}


//*************************************************************************************
void CRfid1demoDlg::OnBnClickedRadioFindtags()
{
	if(valid_port==0)
		return;

	KillTimer(100);

	UpdateData(TRUE);
	m_PortStatus.Format(_T("Resetting module"));
	UpdateData(FALSE);
	UpdateWindow();

	reset_module();

	UpdateData(TRUE);
	m_PortStatus.Format(_T("Module ready"));
	UpdateData(FALSE);
	UpdateWindow();

	SetTimer(100, 250, NULL);
}




//*************************************************************************************
void CRfid1demoDlg::OnBnClickedRadioInventory()
{
	if(valid_port==0)
		return;

	KillTimer(100);

	PingReader();

	UpdateData(TRUE);
	m_PortStatus.Format(_T("16-Slot Inventory"));
	UpdateData(FALSE);
	UpdateWindow();

	SendRegwrtreq();//set ISO15693 protocol
	SendAgcToggle();
	SendAmPmToggle();

	SetTimer(100, 250, NULL);
}




//*************************************************************************************
void CRfid1demoDlg::OnBnClickedRadioInventory2() //read single slot
{
	if(valid_port==0)
		return;

	KillTimer(100);

	PingReader();//ping to stop the find tags mode
	PingReader();//ping again to clear the buffer

	UpdateData(TRUE);
	m_PortStatus.Format(_T("1-Slot Inventory"));
	UpdateData(FALSE);
	UpdateWindow();

	SendRegwrtreq();//set ISO15693 protocol
	SendAgcToggle();
	SendAmPmToggle();

	SetTimer(100, 250, NULL);

}



//*************************************************************************************
void CRfid1demoDlg::OnBnClickedRadioManualmode()
{
	if(valid_port==0)
		return;

	UpdateData(TRUE);
	m_PortStatus.Format(_T("Manual Mode"));
	UpdateData(FALSE);
	UpdateWindow();

	KillTimer(100);
}


//*************************************************************************************
void CRfid1demoDlg::OnBnClickedButtonPing()
{
	CString sss;

	int res = PingReader();
	if(res==0)//no error
	{
			sss.Format("RFID2 Ready");
			m_SniffList.InsertString(0,sss);
			UpdateWindow();
	}
	else
	{
		sss.Format("No RFID2 Detected");
		m_SniffList.InsertString(0,sss);
		UpdateWindow();
		//AfxMessageBox("Error: No reader detected.");				
	}
}


//**********************************************************************************************
int CRfid1demoDlg::PingReader() 
{
	FT_STATUS status;
	unsigned char tx[50], rx[200];
	CString stra, str, sss;
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;
	int pos;
	
	for(pos=0; pos<50; pos++)
		rx[pos] = 0xCC;


	//Ping the port and check for correct response
	pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x38;//8

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x46;//F
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	status = FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	if(AmountInRxQueue>195) AmountInRxQueue = 195;
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);

	if(BytesReturned < 15)
	{
		sss.Format("RFID2 not found");
		m_SniffList.InsertString(0,sss);
		UpdateWindow();
		return 1;
	}

	//disabled because lots of data can be returned in find tags mode
	//if(BytesReturned > 25)
	//{
	//	sss.Format("RFID2 not found or tag(s) present in field");
	//	m_SniffList.InsertString(0,sss);
	//	UpdateWindow();
	//	return 1;
	//}

	for(DWORD x=0; x<BytesReturned; x++)
	{
		stra.Format("%c", rx[x]);
		str+=stra;
	}

	pos = str.Find("TRF7970A EVM", 0);  
	if(pos>=0)
	{      
		//pass
	}
	else   //fail
	{
		sss.Format("RFID2 not found");
		m_SniffList.InsertString(0,sss);
		UpdateWindow();
		PurgePort();
		return 2;
	}
	
	PurgePort();

	return 0;
}



//**********************************************************************
void CRfid1demoDlg::PurgePort()
{
	unsigned char pbuf[500];
	DWORD AmountInRxQueue, BytesReturned;

	Sleep(20);//wait for data to arrive
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	if(AmountInRxQueue>499) AmountInRxQueue=499;

	while(AmountInRxQueue)
	{
		FT_Read(m_ftHandle, pbuf, AmountInRxQueue, &BytesReturned);
		Sleep(1);//wait for more to arrive
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
		if(AmountInRxQueue>499) AmountInRxQueue=499;
	}
}


//**********************************************************************
DWORD CRfid1demoDlg::FastRead(int count, int timeout)
{
	DWORD AmountInRxQueue, BytesReturned;

	
	if(count>MYBUFFERSIZE)
	{
		KillTimer(100);
		AfxMessageBox("array error 2");
		return 1;
	}

	AmountInRxQueue=0;
	while((timeout--) && (AmountInRxQueue<(DWORD)count))
	{
		Sleep(1);
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	}

	if(AmountInRxQueue <= (DWORD)count)
		FT_Read(m_ftHandle, grx, AmountInRxQueue, &BytesReturned);
	else
		FT_Read(m_ftHandle, grx, count, &BytesReturned);

	return AmountInRxQueue;
}


//0x30 = 0
//0x39 = 9
//0x41 = A
//0x42 = B
//0x43 = C
//0x44 = D
//0x45 = E
//0x46 = F


//**********************************************************************
void CRfid1demoDlg::SendRegwrtreq()
{
	DWORD BytesWritten;
	unsigned char tx[600];
	CString stra, str;

	PurgePort();
	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x43;//C

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1  register write
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0  register 0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2  data=0x21
	tx[pos++] = 0x31;//1

	tx[pos++] = 0x30;//0 register 1
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	PurgePort();
	//ret = FastRead(0x19, 50);
}




//**********************************************************************
void CRfid1demoDlg::SendAgcToggle() 
{
	DWORD BytesWritten;
	unsigned char tx[600];
	CString stra, str;
	

	PurgePort();

	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	PurgePort();
	//ret = FastRead(0x0C, 50);

}


/*
//**********************************************************************
void CRfid1demoDlg::FixRegister18()
{
	DWORD BytesWritten;
	unsigned char tx[600];
	CString stra, str;


	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x41;//A
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	int ret = FastRead(0x12, 50);
}*/



//**********************************************************************
void CRfid1demoDlg::SendAmPmToggle() 
{
	DWORD BytesWritten;
	unsigned char tx[600];
	CString stra, str;

	PurgePort();


	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x46;//F
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x46;//F

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	PurgePort();
	//ret = FastRead(0x14, 50);

}




//0x30 = 0
//0x39 = 9
//0x41 = A
//0x42 = B
//0x43 = C
//0x44 = D
//0x45 = E
//0x46 = F

//**********************************************************************
void CRfid1demoDlg::ReadSingleSlot()
{
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;
	char str_src[3000];
	char str_dest[3000];
	unsigned char tx[3000];
	DWORD ret_bytes, x;
	CString stra, str;
	int TotNumTags;

	PurgePort();

	for(x=0; x<MYBUFFERSIZE; x++)
		grx[x]=0xcc;

	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	//single slot inventory
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1  

	//16 slot inventory
	//tx[pos++] = 0x31;//1
	//tx[pos++] = 0x34;//4
	//tx[pos++] = 0x30;//0	   
	//tx[pos++] = 0x34;//4
	//tx[pos++] = 0x30;//0
	//tx[pos++] = 0x31;//1

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 

	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	while(AmountInRxQueue < 0x1E)//size of return if no tag present
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	Sleep(100);//allow for tag data present
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, grx, AmountInRxQueue, &BytesReturned);//read in 1 byte at a time




	m_SniffList.ResetContent();
	UpdateWindow();
	TotNumTags=0;

	ret_bytes = BytesReturned;
	for(x=0; x<ret_bytes; x++)
	{
		if(grx[x] == '[')
		{
			x++;
			str.Format(" ");
			int indx=0;
			while(grx[x] != ',')
			{
				stra.Format("%c", grx[x]);
				x++;
				indx++;
				str+=stra;
				if(indx>35)
				{
					str.Format(" ");
					break;
				}
			}
		
			if(str.GetLength() >6)//if a UID was found...
			{
				strcpy(str_src, (LPCTSTR)str);

				//byte reverse
				int ptr=15;
				for(int t=0; t<16; t+=2)
				{
					str_dest[t] = str_src[ptr];
					str_dest[t+1] = str_src[ptr+1];
					str_dest[t+2] = NULL;
					ptr-=2;
				}

				CString sss;
				sss.Format("%s", str_dest);
				m_SniffList.InsertString(0,"UID:"+sss);//display the UID
				TotNumTags++;
			}
		}
	}

	UpdateData(TRUE);
	m_NumTags.Format("%d tags", TotNumTags);
	UpdateData(FALSE);
	UpdateWindow();

	if(TotNumTags==0)
	{
		CString sss;
		sss.Format("NO      TAGS      FOUND");
		m_SniffList.InsertString(0,sss);
		UpdateWindow();
	}

	Sleep(20);//wait for any stragglers

	PurgePort();
}



//**********************************************************************
void CRfid1demoDlg::Read16slot() 
{
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;
	char str_src[3000];
	char str_dest[3000];
	unsigned char tx[3000];
	DWORD ret_bytes, x;
	CString stra, str;
	int TotNumTags;

	PurgePort();

	for(x=0; x < MYBUFFERSIZE; x++)
		grx[x]=0xcc;

	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	//single slot inventory
	//tx[pos++] = 0x31;//1
	//tx[pos++] = 0x34;//4
	//tx[pos++] = 0x32;//2
	//tx[pos++] = 0x34;//4
	//tx[pos++] = 0x30;//0
	//tx[pos++] = 0x31;//1  

	//16 slot inventory
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x30;//0	   
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	ret_bytes = GetBufferSlow();

	m_SniffList.ResetContent();
	UpdateWindow();
	TotNumTags=0;

	for(x=0; x<ret_bytes; x++)
	{
		if(grx[x] == '[')
		{
			x++;
			str.Format(" ");
			int indx=0;
			while(grx[x] != ',')
			{
				stra.Format("%c", grx[x]);
				x++;
				indx++;
				str+=stra;
				if(indx>35)
				{
					str.Format(" ");
					break;
				}
			}
		
			if(str.GetLength() >6)//if a UID was found...
			{
				strcpy(str_src, (LPCTSTR)str);

				//byte reverse
				int ptr=15;
				for(int t=0; t<16; t+=2)
				{
					str_dest[t] = str_src[ptr];
					str_dest[t+1] = str_src[ptr+1];
					str_dest[t+2] = NULL;
					ptr-=2;
				}

				CString sss;
				sss.Format("%s", str_dest);
				m_SniffList.InsertString(0,"UID:"+sss);//display the UID
				TotNumTags++;
			}
		}
	}

	PurgePort();

	UpdateData(TRUE);
	m_NumTags.Format("%d tags", TotNumTags);
	UpdateData(FALSE);
	UpdateWindow();

	if(TotNumTags==0)
	{
		CString sss;
		sss.Format("NO      TAGS      FOUND");
		m_SniffList.InsertString(0,sss);
		UpdateWindow();
	}

	Sleep(20);//wait for any stragglers

	PurgePort();
}



//**********************************************************************
DWORD CRfid1demoDlg::GetBufferSlow()
{
	unsigned char temprx[1];
	DWORD AmountInRxQueue, BytesReturned;
	int timeoutcount;

	int found=0, index=0;
	while(found==0)//while the end of data has not been found...
	{
		timeoutcount=70;
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
		while (AmountInRxQueue==0)//wait for at least one byte in the buffer with timeout
		{
			Sleep(10);
			timeoutcount--;
			if(timeoutcount==0)	
			{
				found=1;//terminate loop/function
				break;
			}
			FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
		}

		if(AmountInRxQueue>0)//if one byte is ready to be read
		{
			timeoutcount=6;
			FT_Read(m_ftHandle, temprx, 1, &BytesReturned);//read in 1 byte at a time
			grx[index++] = temprx[0];
			if(index > MYBUFFERSIZE-10)
				found=1;//terminate loop/function
		}
		else        //timeout
			found=1;//terminate loop/function
	}

	return index;
}


//*****************************************************************************
DWORD CRfid1demoDlg::hex2dec(char *addr)
{
	DWORD a, b, c, d, e, f, g, h;

	if(strlen(addr) == 1)
		return ascitohex(*addr);

	if(strlen(addr) == 2)
	{
		a = ascitohex(*addr) << 4;
		addr++;
		b = ascitohex(*addr);
		return a | b;
	}

	if(strlen(addr) == 3)
	{
		a = ascitohex(*addr) << 8;
		addr++;
		b = ascitohex(*addr) << 4;
		addr++;
		c = ascitohex(*addr);
		return a | b | c;
	}

	if(strlen(addr) == 4)
	{
		a = ascitohex(*addr) << 12;
		addr++;
		b = ascitohex(*addr) << 8;
		addr++;
		c = ascitohex(*addr) << 4;
		addr++;
		d = ascitohex(*addr);
		return a | b | c | d;
	}

	if(strlen(addr) == 5)
	{
		a = ascitohex(*addr) << 16;
		addr++;
		b = ascitohex(*addr) << 12;
		addr++;
		c = ascitohex(*addr) << 8;
		addr++;
		d = ascitohex(*addr) << 4;
		addr++;
		e = ascitohex(*addr);
		return a | b | c | d | e;
	}

	if(strlen(addr) == 6)
	{
		a = ascitohex(*addr) << 20;
		addr++;
		b = ascitohex(*addr) << 16;
		addr++;
		c = ascitohex(*addr) << 12;
		addr++;
		d = ascitohex(*addr) << 8;
		addr++;
		e = ascitohex(*addr) << 4;
		addr++;
		f = ascitohex(*addr);
		return a | b | c | d | e | f;
	}

	if(strlen(addr) == 7)
	{
		a = ascitohex(*addr) << 24;
		addr++;
		b = ascitohex(*addr) << 20;
		addr++;
		c = ascitohex(*addr) << 16;
		addr++;
		d = ascitohex(*addr) << 12;
		addr++;
		e = ascitohex(*addr) << 8;
		addr++;
		f = ascitohex(*addr) << 4;
		addr++;
		g = ascitohex(*addr);
		return a | b | c | d | e | f | g;
	}
	
	if(strlen(addr) == 8)
	{
		DWORD x;

		x=0;
		a = ascitohex(*addr) << 28;
		addr++;
		x |= a;
		b = ascitohex(*addr) << 24;
		addr++;
		x |= b;
		c = ascitohex(*addr) << 20;
		addr++;
		x |= c;
		d = ascitohex(*addr) << 16;
		addr++;
		x |= d;
		e = ascitohex(*addr) << 12;
		addr++;
		x |= e;
		f = ascitohex(*addr) << 8;
		addr++;
		x |= f;
		g = ascitohex(*addr) << 4;
		addr++;
		x |= g;
		h = ascitohex(*addr);
		x |= h;

		//x = a | b | c | d | e | f | g | h; 

		return x;
	}

	return 0;
}

//**********************************************************************
void CRfid1demoDlg::Read8Blocks(int section) //read 8 4-byte blocks starting at section
{
	char str_src[3000];
	char str_dest[3000];
	DWORD x;
	unsigned char tx[1000];//, rx[1000];//, strr[300];
	DWORD ret_bytes;
	CString stra, str;
	DWORD BytesWritten;

	PurgePort();

	for(x=0; x<2000; x++)
		grx[x] = 0;

	for(x=0; x<3000; x++)
	{
		str_src[x] = 0;
		str_dest[x] = 0;
	}

	//build and send the Read block command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x43;//C

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8		
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x33;//3

	if(section==0)//block 0-7
	{	
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
	}
	if(section==1)//block 8-15
	{	
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x38;//8
	}
	if(section==2)//block 16-23
	{	
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x30;//0
	}
	if(section==3)//block 24-31
	{	
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x38;//8
	}

	if(section==4)//block 32-39
	{	
		tx[pos++] = 0x32;//2
		tx[pos++] = 0x30;//0
	}
	if(section==5)//block 40-47
	{	
		tx[pos++] = 0x32;//2
		tx[pos++] = 0x38;//8
	}
	if(section==6)//block 48-55
	{	
		tx[pos++] = 0x33;//3
		tx[pos++] = 0x30;//0
	}
	if(section==7)//block 56-63
	{	
		tx[pos++] = 0x33;//3
		tx[pos++] = 0x38;//8
	}
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x37;//7
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	PurgePort();
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	ret_bytes = FastRead(127, 100);

	if(ret_bytes != 0x65)
	{
		//AfxMessageBox("error1");
		str.Format("(No Tag Found)");
		UpdateData(TRUE);
		m_MyText+=str;
		UpdateData(FALSE);
		UpdateWindow();

	   	//Initialize port ********************
		//set DTR
		FT_SetDtr(m_ftHandle);
		Sleep(20); //wait for cap to charge
		//Clear DTR
		FT_ClrDtr(m_ftHandle);
		Sleep(110);//wait for micro to start up

		PingReader();
		PurgePort();
		PingReader();
		PurgePort();

		return;
	}


	pos=0;

	while(grx[pos++] != '[')//find starting brace
	{
		if((DWORD)pos>ret_bytes)
		{
			AfxMessageBox("error2");
			return;
		}	
	}

	pos+=4;
	stra.Format("");
	for(x=0; x<8; x++)
	{
		int count=8;
		str.Format("");
		while(count--)
		{
			stra.Format("%c", grx[pos++]);
			str+=stra;
		}
	
		pos+=2;
	
		data8[x] = 0;//init
		if(str.GetLength() ==8)//if a read was performed
		{
			strcpy(str_src, (LPCTSTR)str);
			//byte reverse
			int ptr=6;
			for(int t=0; t<8; t+=2)
			{
				str_dest[t] = str_src[ptr];
				str_dest[t+1] = str_src[ptr+1];
				str_dest[t+2] = NULL;
				ptr-=2;
			}
			data8[x] = hex2dec(str_dest);
		}
	}

	return;
}



//**************************************************************************************
void CRfid1demoDlg::OnButtonread() 
{
	int pos, y;
	char b1, b2, b3, b4;
	CString str;
	DWORD data;

	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID2 Reader not found");
		return;
	}


	PurgePort();

	UpdateData(TRUE);
	m_MyText = _T("");
	m_PortStatus = _T("Reading Tag...");
	UpdateData(FALSE);
	UpdateWindow();

	//determine the type of tag
	CString single = ReadBothReturnOne();
	if(single.GetLength() < 5)
	{
		m_SniffList.InsertString(0, "Tag not foud.");
		UpdateWindow();
		return;
	}

	m_SniffList.InsertString(0, single);
	UpdateWindow();

	CString type;
	type = single.Mid(4, 2);
	int dtype = hex2dec((char *)(LPCTSTR)type);	
	dtype &= 0xFE; //clear the lsb

	SendRegwrtreq();//set ISO15693 protocol
	SendAgcToggle();
	SendAmPmToggle();

	if( (dtype == 0x00) || (dtype == 0x80))//HF-I Plus 
	{
		//change Static text to read 256 Max characters
		GetDlgItem(IDC_STATIC_MAX_COUNT)->SetWindowText("Max:256");

		m_Progress.SetRange(0, 100);
		m_Progress.SetPos(0);

		for(int x=0; x<8; x++)
		{
			pos = (int)((float)x/(float)7.0*100.00);
			m_Progress.SetPos(pos);

			for(y=0; y<8; y++)
				data8[y]=0;

			Read8Blocks(x);//data stored in data8[x]
			for(y=0; y<8; y++)
			{
				b1 = (data8[y]>>24) & 0x000000FF;
				b2 = (data8[y]>>16) & 0x000000FF;
				b3 = (data8[y]>>8) & 0x000000FF;
				b4 = data8[y] & 0x000000FF;
				str.Format("%c%c%c%c", b1, b2, b3, b4);
				
				UpdateData(TRUE);
				m_MyText+=str;
				UpdateData(FALSE);
				UpdateWindow();
			}
		}
	}
   else//Pro/Standard Read (one block at a time)
   {
		//change Static text to read 32 Max characters
		GetDlgItem(IDC_STATIC_MAX_COUNT)->SetWindowText("Max:32");

	   
	    m_Progress.SetRange(0, 7);
		m_Progress.SetPos(0);

		int error_code;
		for(int loop=0; loop<8; loop++)
		{
			m_Progress.SetPos(loop);
			data = ReadSingleBlock(loop, &error_code);

			b1 = (char)(data>>24) & 0x000000FF;
			b2 = (char)(data>>16) & 0x000000FF;
			b3 = (char)(data>>8) & 0x000000FF;
			b4 = (char)data & 0x000000FF;
			str.Format("%c%c%c%c", b1, b2, b3, b4);
			
			UpdateData(TRUE);
			m_MyText+=str;
			UpdateData(FALSE);
			UpdateWindow();
		}

   }

	OnChangeEditMytext();	
}




//********************************************************************************
void CRfid1demoDlg::OnChangeEditMytext() 
{
	UpdateData(TRUE);
	m_NumChars = m_MyText.GetLength();
	m_PortStatus = _T("Editing...");
	UpdateData(FALSE);
	UpdateWindow();
}




//********************************************************************************
void CRfid1demoDlg::OnButtonClear() 
{
	UpdateData(TRUE);
	m_MyText = _T("");
	UpdateData(FALSE);
	UpdateWindow();
	OnChangeEditMytext();
}




//********************************************************************************
void CRfid1demoDlg::OnButtonWriteTag() 
{
	unsigned char tx[100], rx[100], strj[10], stry[5]; 
	CString strr;
	CString stra, str, pos_str;
	int address, pos;
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID2 Reader not found");
		return;
	}


	UpdateData(TRUE);
	m_PortStatus = _T("Writing Tag...");
	UpdateData(FALSE);
	UpdateWindow();

	
	int uu = m_MyText.GetLength() % 4;
	if(uu ==1) 
		m_MyText += _T("   ");
	if(uu ==2) 
		m_MyText += _T("  ");
	if(uu ==3) 
		m_MyText += _T(" ");

	while(m_MyText.GetLength() <=256)//file out the text with whitespace
		m_MyText += _T("    ");


	SendRegwrtreq();//set ISO15693 protocol
	SendAgcToggle();
	SendAmPmToggle();

	m_Progress.SetRange(0, 100);
	m_Progress.SetPos(0);


	for(address=0; address<m_MyText.GetLength()/4; address++)
	{
		pos = (int)((float)address/(float)64.0*100.00);
		m_Progress.SetPos(pos);

		sprintf((char *)strj, "%02.2X", address);

		int b1 = strj[0];
		int b2 = strj[1];

	
		strr = m_MyText.Mid(address*4, 4);
		

		sprintf((char *)strj, "%s", (LPCTSTR)strr);//This

		sprintf((char *)stry, "%02.2X", strj[0]);
		int b3 = stry[0];
		int b4 = stry[1];

		sprintf((char *)stry, "%02.2X", strj[1]);
		int b5 = stry[0];
		int b6 = stry[1];
		
		sprintf((char *)stry, "%02.2X", strj[2]);
		int b7 = stry[0];
		int b8 = stry[1];
		
		sprintf((char *)stry, "%02.2X", strj[3]);
		int b9 = stry[0];
		int b10 = stry[1];


		//build and send the Read block command
		int pos=0;
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x46;//F

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x33;//3
		
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x34;//4
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x38;//8
			
		tx[pos++] = 0x34;//4
		tx[pos++] = 0x30;//0

		tx[pos++] = 0x32;//2
		tx[pos++] = 0x31;//1
		tx[pos++] = b1;//addr
		tx[pos++] = b2;//addr
		
		tx[pos++] = b9;//data
		tx[pos++] = b10;//data
		tx[pos++] = b7;//data
		tx[pos++] = b8;//data
		tx[pos++] = b5;//data
		tx[pos++] = b6;//data
		tx[pos++] = b3;//data
		tx[pos++] = b4;//data

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
	
		FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
		Sleep(50);
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
		FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
	}

	
	UpdateData(TRUE);
	m_PortStatus = _T("Done.");;
	UpdateData(FALSE);
	UpdateWindow();
}




//********************************************************************************
void CRfid1demoDlg::OnButtonTestPattern() 
{
	unsigned char tx[100], rx[100], strj[10]; 
	CString strr;
	CString stra, str, pos_str;
	int address, pos;
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID2 Reader not found");
		return;
	}


	UpdateData(TRUE);
	m_PortStatus = _T("Writing Test Pattern...");
	UpdateData(FALSE);
	UpdateWindow();


	SendRegwrtreq();//set ISO15693 protocol
	SendAgcToggle();
	SendAmPmToggle();

	m_Progress.SetRange(0, 100);
	m_Progress.SetPos(0);


	for(address=0; address<256; address+=4)
	{
		pos = (int)((float)address/(float)256.0*100.00);
		m_Progress.SetPos(pos);

		sprintf((char *)strj, "%02.2X", address/4);

		int b1 = strj[0];
		int b2 = strj[1];


		//data =  hex2dec((char *)(LPCTSTR)m_Data);	
		sprintf((char *)strj, "%02.2X%02.2X%02.2X%02.2X", address, address+1, address+2, address+3);
		int b3 = strj[0];
		int b4 = strj[1];
		int b5 = strj[2];
		int b6 = strj[3];
		int b7 = strj[4];
		int b8 = strj[5];
		int b9 = strj[6];
		int b10 = strj[7];



		//build and send the Read block command
		int pos=0;
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x46;//F

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x33;//3
		
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x34;//4
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x38;//8
			
		tx[pos++] = 0x34;//4
		tx[pos++] = 0x30;//0

		tx[pos++] = 0x32;//2
		tx[pos++] = 0x31;//1
		tx[pos++] = b1;//addr
		tx[pos++] = b2;//addr
		
		tx[pos++] = b9;//data
		tx[pos++] = b10;//data
		tx[pos++] = b7;//data
		tx[pos++] = b8;//data
		tx[pos++] = b5;//data
		tx[pos++] = b6;//data
		tx[pos++] = b3;//data
		tx[pos++] = b4;//data

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		
		FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
		Sleep(50);
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
		FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
	}




	UpdateData(TRUE);
	m_PortStatus = _T("Done.");;
	UpdateData(FALSE);
	UpdateWindow();
}



//**************************************************************************
void CRfid1demoDlg::WriteSingleBlock(DWORD address, int data) 
{
	unsigned char tx[100], rx[1000], strr[30];
	CString stra, str;
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	SendRegwrtreq();//set ISO15693 protocol
	SendAgcToggle();
	SendAmPmToggle();

	sprintf((char *)strr, "%02.2X", address);
	int b1 = strr[0];
	int b2 = strr[1];

	sprintf((char *)strr, "%08.8X", data);
	int b3 = strr[0];
	int b4 = strr[1];
	int b5 = strr[2];
	int b6 = strr[3];
	int b7 = strr[4];
	int b8 = strr[5];
	int b9 = strr[6];
	int b10 = strr[7];


	//build and send the Read block command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x46;//F

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8
		
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x31;//1
	tx[pos++] = b1;//addr
	tx[pos++] = b2;//addr
	
	tx[pos++] = b9;//data
	tx[pos++] = b10;//data
	tx[pos++] = b7;//data
	tx[pos++] = b8;//data
	tx[pos++] = b5;//data
	tx[pos++] = b6;//data
	tx[pos++] = b3;//data
	tx[pos++] = b4;//data

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);

}


//**************************************************************************
void CRfid1demoDlg::OnButtonWriteSingle() 
{
	CString stra, str;
	int address, data;

	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID2 Reader not found");
		return;
	}

	UpdateData(TRUE);
	if(m_Addr.GetLength() > 2)
	{
		AfxMessageBox("Invalid Entry.  Range: 00-FF");
		return;
	}

	if(m_Data.GetLength() != 8)
	{
		AfxMessageBox("Invalid Entry.  Range: 00000000-FFFFFFFF");
		return;
	}

	address = hex2dec((char *)(LPCTSTR)m_Addr);	
	data =  hex2dec((char *)(LPCTSTR)m_Data);	

	WriteSingleBlock(address, data);
}




//************************************************************************************
DWORD CRfid1demoDlg::ReadSingleBlock(int addr, int *error) //return hex value
{
	char str_src[3000];
	char str_dest[3000];
	DWORD x;
	unsigned char tx[100], rx[100], strr[3];
	CString stra, str;
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;


	*error=0;//init to no error

	SendRegwrtreq();//set ISO15693 protocol
	SendAgcToggle();
	SendAmPmToggle();

	sprintf((char *)strr, "%02.2X", addr);

	int b1 = strr[0];//F
	int b2 = strr[1];//E



	//build and send the Read block command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x30;//0
	tx[pos++] = b1;//addr
	tx[pos++] = b2;//addr
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(100);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);

	for(x=0; x<BytesReturned; x++)
	{
		if(rx[x] == '[')
		{
			x++;
			str.Format(" ");
			while(rx[x] != ']')
			{
				stra.Format("%c", rx[x]);
				x++;
				str+=stra;
			}
		
			if(str.GetLength() >10)//if a read was performed
			{
				strcpy(str_src, (LPCTSTR)str);
				//byte reverse
				int ptr=9;
				for(int t=0; t<8; t+=2)
				{
					str_dest[t] = str_src[ptr];
					str_dest[t+1] = str_src[ptr+1];
					str_dest[t+2] = NULL;
					ptr-=2;
				}

				DWORD x = hex2dec(str_dest);
				return x;
			}
			else
			{
				*error=1;//no data read
				return 0;
			}
		}
	}

	return 0;//default return
}



//************************************************************************************
void CRfid1demoDlg::OnButtonReadBlock() 
{
	CString stra, str;
	int address;
	int error_code;


	UpdateData(TRUE);
	m_Data = _T("");
	UpdateData(FALSE);
	UpdateWindow();


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID2 Reader not found");
		return;
	}

	if(m_Addr.GetLength() > 2)
	{
		AfxMessageBox("Invalid Entry.  Range: 00-FF");
		return;
	}

	address = hex2dec((char *)(LPCTSTR)m_Addr);	

	DWORD data = ReadSingleBlock(address, &error_code);
	if(error_code)
	{
		AfxMessageBox("ERROR: Invalid data returned.");
		return;
	}

	UpdateData(TRUE);
	m_Data.Format("%08.8X", data);
	UpdateData(FALSE);
	UpdateWindow();
}



//***********************************************************************************
void CRfid1demoDlg::OnButtonStayQuiet() 
{
	unsigned char rx[1000], tx[1000], strr[300];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;
	int nIndex, n;

	CString str, str2;
	KillTimer(100);

	SendRegwrtreq();//set ISO15693 protocol
	SendAgcToggle();
	SendAmPmToggle();

	nIndex = m_SniffList.GetCurSel();
	if(nIndex < 0)
	{
		AfxMessageBox("No tag selected.");
		return;
	}

    n = m_SniffList.GetTextLen( nIndex );
    m_SniffList.GetText( nIndex, str.GetBuffer(n) );
    str.ReleaseBuffer();
    str2.Format(_T("%s"), str.GetBuffer(0));//save the selected string
	str2.Delete(0,4);//chop off the header

	sprintf((char *)strr, "%s", (LPCTSTR)str2);
	int b0 = strr[0];
	int b1 = strr[1];
	int b2 = strr[2];
	int b3 = strr[3];
	int b4 = strr[4];
	int b5 = strr[5];
	int b6 = strr[6];
	int b7 = strr[7];
	int b8 = strr[8];
	int b9 = strr[9];
	int b10 = strr[10];
	int b11 = strr[11];
	int b12 = strr[12];
	int b13 = strr[13];
	int b14 = strr[14];
	int b15 = strr[15];


	//build and send the Read block command
	int pos=0;
//	0112000304 182002 AC060424000007E0 0000
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8		
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	
	tx[pos++] = b14;//data
	tx[pos++] = b15;//data
	tx[pos++] = b12;//data
	tx[pos++] = b13;//data
	tx[pos++] = b10;//data
	tx[pos++] = b11;//data
	tx[pos++] = b8;//data
	tx[pos++] = b9;//data
	tx[pos++] = b6;//data
	tx[pos++] = b7;//data
	tx[pos++] = b4;//data
	tx[pos++] = b5;//data
	tx[pos++] = b2;//data
	tx[pos++] = b3;//data
	tx[pos++] = b0;//data
	tx[pos++] = b1;//data

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);

}




//***********************************************************************************
void CRfid1demoDlg::OnButtonReset() 
{
	unsigned char rx[1000], tx[1000];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	//build and send the disable command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x46;//f
	tx[pos++] = 0x46;//f
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);

//	Sleep(110);//wait for micro to start up

	//set DTR
	FT_SetDtr(m_ftHandle);
	Sleep(20); //wait for cap to charge
	//Clear DTR
	FT_ClrDtr(m_ftHandle);
	Sleep(110);//wait for micro to start up

	int ret = PingReader();
	if(ret)
		AfxMessageBox("Ping failed.");

}




//**********************************************************************
CString CRfid1demoDlg::ReadBothReturnOne() 
{
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;
	char str_src[3000];
	char str_dest[3000];
	unsigned char tx[3000];
	DWORD ret_bytes, x;
	CString stra, str;
	CString sss;
	int TotNumTags;

	SendRegwrtreq();//set ISO15693 protocol
	SendAgcToggle();
	SendAmPmToggle();

	PurgePort();

	//single slot inventory
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1
	tx[pos++] = 0x34;//4		
	tx[pos++] = 0x32;//2 was 0
	tx[pos++] = 0x34;//4 was 6
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	while(AmountInRxQueue < 0x1E)//size of return if no tag present
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	Sleep(100);//allow for tag data present
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, grx, AmountInRxQueue, &BytesReturned);//read in 1 byte at a time

	m_SniffList.ResetContent();
	UpdateWindow();
	TotNumTags=0;
	ret_bytes = BytesReturned;
	for(x=0; x<ret_bytes; x++)
	{
		if(grx[x] == '[')
		{
			x++;
			str.Format(" ");
			int indx=0;
			while(grx[x] != ',')
			{
				stra.Format("%c", grx[x]);
				x++;
				indx++;
				str+=stra;
				if(indx>35)
				{
					str.Format(" ");
					break;
				}
			}
		
			if(str.GetLength() >6)//if a UID was found...
			{
				strcpy(str_src, (LPCTSTR)str);

				//byte reverse
				int ptr=15;
				for(int t=0; t<16; t+=2)
				{
					str_dest[t] = str_src[ptr];
					str_dest[t+1] = str_src[ptr+1];
					str_dest[t+2] = NULL;
					ptr-=2;
				}

				sss.Format("%s", str_dest);
				return sss;
			}
		}
	}


	PurgePort();

	Sleep(40);//wait for any stragglers

	PurgePort();

	sss.Format(" ");
	return sss;
}






/*
//***********************************************************************************
void CRfid1demoDlg::SilenceTag(CString str2) 
{
	DWORD BytesWritten;
	unsigned char tx[1000], strr[300];

	SendRegwrtreq();//set ISO15693 protocol
	SendAgcToggle();
	SendAmPmToggle();


	sprintf((char *)strr, "%s", (LPCTSTR)str2);
	int b0 = strr[0];
	int b1 = strr[1];
	int b2 = strr[2];
	int b3 = strr[3];
	int b4 = strr[4];
	int b5 = strr[5];
	int b6 = strr[6];
	int b7 = strr[7];
	int b8 = strr[8];
	int b9 = strr[9];
	int b10 = strr[10];
	int b11 = strr[11];
	int b12 = strr[12];
	int b13 = strr[13];
	int b14 = strr[14];
	int b15 = strr[15];


	//build and send the command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8		
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	
	tx[pos++] = b14;//data
	tx[pos++] = b15;//data
	tx[pos++] = b12;//data
	tx[pos++] = b13;//data
	tx[pos++] = b10;//data
	tx[pos++] = b11;//data
	tx[pos++] = b8;//data
	tx[pos++] = b9;//data
	tx[pos++] = b6;//data
	tx[pos++] = b7;//data
	tx[pos++] = b4;//data
	tx[pos++] = b5;//data
	tx[pos++] = b2;//data
	tx[pos++] = b3;//data
	tx[pos++] = b0;//data
	tx[pos++] = b1;//data

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	int ret = FastRead(63, 50);

}
*/



//0x30 = 0
//0x39 = 9
//0x41 = A
//0x42 = B
//0x43 = C
//0x44 = D
//0x45 = E
//0x46 = F



//****************************************************************************************
void CRfid1demoDlg::OnButtonLockBlock() 
{
	unsigned char tx[100], rx[1000], strr[30];
	CString stra, str;
	int address;
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;


	
	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID2 Reader not found");
		return;
	}

	SendRegwrtreq();//set ISO15693 protocol
	SendAgcToggle();
	SendAmPmToggle();

	UpdateData(TRUE);
	if(m_Addr.GetLength() > 2)
	{
		AfxMessageBox("Invalid Entry.  Range: 00-FF");
		return;
	}

	address = hex2dec((char *)(LPCTSTR)m_Addr);	
	sprintf((char *)strr, "%02.2X", address);
	int b1 = strr[0];
	int b2 = strr[1];


	//build and send the Lock block command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8
		
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x32;//2
	tx[pos++] = b1;//addr
	tx[pos++] = b2;//addr

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);	
}



//***********************************************************************************
void CRfid1demoDlg::OnBnClickedButtonIntAnt()
{
	AntennaSelect(0); //0=internal, 1=external
}


//***********************************************************************************
void CRfid1demoDlg::OnBnClickedButtonExtAnt()
{
	AntennaSelect(1); //0=internal, 1=external
}


//**********************************************************************
void CRfid1demoDlg::AntennaSelect(int int_ext_select) //0=internal, 1=external
{
	DWORD BytesWritten;
	unsigned char tx[600];
	CString stra, str;


	PurgePort();

	//Enable Internal Antenna: 01080003042A0000
	//Enable External Antenna: 01080003042B0000

	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x38;//8
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	if(int_ext_select == 0)//internal
		tx[pos++] = 0x41;//A
	else
		tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	PurgePort();
	//ret = FastRead(0x30, 50);
}




